﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Ivi.Driver.Interop;
using Agilent.AgM938x.Interop;

namespace VSG_SFP
{
    public partial class vsgMonitor : Form
    {
        public IAgM938xEx M9381;
        private bool updating;

        public vsgMonitor(IAgM938xEx myM9381)
        {
            InitializeComponent();
            M9381 = myM9381;
            updateGuiControls();
        }
        
        private const int CP_NOCLOSE_BUTTON = 0x200;
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams myCp = base.CreateParams;
                myCp.ClassStyle = myCp.ClassStyle | CP_NOCLOSE_BUTTON;
                return myCp;
            }
        }
        
        private void updateGuiControls()
        {
            updating = true;
            FreqMHzControl.Value = (decimal)(M9381.RF.Frequency /1e6);
            Amp_dBmControl.Value = (decimal)M9381.RF.Level;
            BasebandFreqControl.Value = (decimal)(M9381.Modulation.BasebandFrequency /1e6);
            BasebandPowerControl.Value = (decimal) M9381.Modulation.BasebandPower;
            iqDelayControl.Value = (decimal)((double)M9381.Modulation2.BasebandDelay * 1e9);
            RfEnableControl.Checked = M9381.RF.OutputEnabled;
            ModEnableControl.Checked = M9381.Modulation.Enabled;
            AlcEnableControl.Checked = M9381.ALC.Enabled;
            Application.DoEvents();
            updating = false;
        }

        private void UpdateButton_Click(object sender, EventArgs e)
        {
            updateGuiControls();
        }

        private void M9381_ValueChanged(object sender, EventArgs e)
        {
            if (!updating)
                readGuiControls();
        }

        private void readGuiControls()
        {
            M9381.RF.Frequency = (double)FreqMHzControl.Value * 1e6;
            M9381.RF.Level = (double)Amp_dBmControl.Value;
            M9381.Modulation.BasebandFrequency = (double)BasebandFreqControl.Value * 1e6;
            M9381.Modulation.BasebandPower = (double)BasebandPowerControl.Value;
            M9381.Modulation2.BasebandDelay = (double)iqDelayControl.Value / 1e9;
            M9381.RF.OutputEnabled = RfEnableControl.Checked;
            M9381.Modulation.Enabled = ModEnableControl.Checked;
            M9381.ALC.Enabled = AlcEnableControl.Checked;
            M9381.Apply();
        }

    }
}
